package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.datatype.model.P06B22T00Datatype;
import com.ejie.p06b.datatype.model.P06B64T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (09/05/07)
 */
public class P06B20T00DAO {

	static private P06B20T00DAO instance = null;

	public static P06B20T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B20T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B20T00DAO();
	                }
	          }
	     }
	     return instance;
	}

	/**
    * Inserta un registro de la BD
    * @param obj.
    *            objeto a insertar
    * @return String -> El numero de expediente generado
    * @throws SQLException
    */
	public String insert(P06B20T00Datatype obj) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B20T00DAO-insert");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        //Antes calculo el expediente siguiente a asignar
        String numExp = this.calcularSteExp(lconConexion, obj.getClase());
        String sql = INSERT_COMPLETA;
        lstm = lconConexion.prepareStatement(sql);

    	lstm.setString(1,numExp.toUpperCase());
    	lstm.setString(2,obj.getClase().toUpperCase());
    	lstm.setString(3,obj.getDni().toUpperCase());
    	lstm.setString(4,obj.getRazsoc().toUpperCase());
    	lstm.setString(5,obj.getNombre().toUpperCase());
    	lstm.setString(6,obj.getApe1().toUpperCase());
    	lstm.setString(7,obj.getApe2().toUpperCase());
    	lstm.setString(8,obj.getDomici().toUpperCase());
    	lstm.setString(9,obj.getCodmun().toUpperCase());
    	lstm.setString(10,obj.getLocali().toUpperCase());
    	lstm.setString(11,obj.getCodpro().toUpperCase());
    	lstm.setString(12,obj.getCodpst().toUpperCase());
    	lstm.setString(13,obj.getTelefot().toUpperCase());
    	lstm.setString(14,obj.getTelefom().toUpperCase());
    	lstm.setString(15,obj.getTelefoc().toUpperCase());
    	lstm.setString(16,obj.getFax1().toUpperCase());
    	lstm.setString(17,obj.getFax2().toUpperCase());
    	lstm.setString(18,obj.getMail().toUpperCase());
    	lstm.setString(19,obj.getWeb().toUpperCase());
    	lstm.setString(20,obj.getCurso().toUpperCase());
    	lstm.setString(21,obj.getDenCurso().toUpperCase());
    	lstm.setString(22,obj.getAcredita().toUpperCase());
    	lstm.setString(23,obj.getDAcredita().toUpperCase());
    	lstm.setString(24,obj.getEstado().toUpperCase());
    	lstm.setString(25,obj.getFechaAl().toUpperCase());
    	lstm.setString(26,obj.getFechaBaj().toUpperCase());
    	lstm.setString(27,obj.getMotivoB().toUpperCase());
    	lstm.setString(28,obj.getFechaSus().toUpperCase());
    	lstm.setString(29,obj.getMotivoS().toUpperCase());
    	lstm.setString(30,obj.getFecFinSu().toUpperCase());
    	if(obj.getCapsoc().equals("")){
    		lstm.setString(31,null);
    	}else{
    		lstm.setDouble(31, Double.parseDouble(obj.getCapsoc()));
    	}
//    	Por si se meten . en el campo
    	lstm.setString(32,obj.getPaticipa().toUpperCase());
    	lstm.setString(33,obj.getDProFor().toUpperCase());
    	lstm.setString(34,obj.getActIns().toUpperCase());
    	lstm.setString(35,obj.getTrasdgs().toUpperCase());
    	lstm.setInt(36,obj.getUltEjerIncorporado());
    	lstm.setInt(37,obj.getUltAtencPeticIncorporada());

    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
        try {
        	if(lconConexion!=null)lconConexion.close();
        }catch (Exception cse) {}
        P06BLog.send(2,this, "Fin P06B20T00DAO-insert Devuelve:"+numExp);
        return numExp.toUpperCase();
	}

	/**
    * Modifica un registro de la BD
    * @param obj.
    *            objeto a modificar
    * @return String -> El numero de expediente modificado
    * @throws SQLException
    */
	public String update(P06B20T00Datatype obj) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B20T00DAO-update");

        String sql = UPDATE_COMPLETA;
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE  "+ P06BTablas.P06B_P06B20T00_TABLA + " SET ");
        boolean bComaPendiente = false;
        if (obj.getDatosAtencionPeticionEnRevision()==null || obj.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
            sb.append(P06BTablas.P06B_P06B20_IDENTIFICADOR + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_RAZSOC + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_NOMBRE + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_APE1 + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_APE2 + "=?, ");
    		if (obj.getDatosAtencionPeticionEnRevision()==null || obj.getDatosAtencionPeticionEnRevision().isbActualizarDomicilioSocial()){
    	        sb.append(P06BTablas.P06B_P06B20_DOMICI + "=?, ");
    	        sb.append(P06BTablas.P06B_P06B20_CODMUN + "= TO_NUMBER(?), ");
    	        sb.append(P06BTablas.P06B_P06B20_LOCALI + "= TO_NUMBER(?), ");
    	        sb.append(P06BTablas.P06B_P06B20_CODPRO + "= TO_NUMBER(?), ");
    	        sb.append(P06BTablas.P06B_P06B20_CODPST + "=?, ");
    	        sb.append(P06BTablas.P06B_P06B20_TELEFOT + "=?, ");
    	        sb.append(P06BTablas.P06B_P06B20_MAIL + "=?, ");
    	        sb.append(P06BTablas.P06B_P06B20_WEB + "=?, ");
    		}
            sb.append(P06BTablas.P06B_P06B20_TELEFOM + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_TELEFOC + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_FAX1 + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_FAX2 + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_CURSO + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_DENCURSO + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_ACREDITA + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_DACREDITA + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_ESTADO + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_FECHAAL + "= TO_DATE(?,'dd/MM/yyyy'), ");
            sb.append(P06BTablas.P06B_P06B20_FECHABAJ + "= TO_DATE(?,'dd/MM/yyyy'), ");
            sb.append(P06BTablas.P06B_P06B20_MOTIVOB + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_FECHASUS + "= TO_DATE(?,'dd/MM/yyyy'), ");
            sb.append(P06BTablas.P06B_P06B20_MOTIVOS + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_FECFINSU + "= TO_DATE(?,'dd/MM/yyyy'), ");
    		if (obj.getDatosAtencionPeticionEnRevision()==null || obj.getDatosAtencionPeticionEnRevision().isbActualizarCapitalSocial()){
    	        sb.append(P06BTablas.P06B_P06B20_CAPSOC + "=?, ");
    	        sb.append(P06BTablas.P06B_P06B20_PATICIPA + "= TO_NUMBER(?), ");
    		}
            sb.append(P06BTablas.P06B_P06B20_DPROFOR + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_ACTINS + "=?, ");
            sb.append(P06BTablas.P06B_P06B20_TRASDGS + "= TO_DATE(?,'dd/MM/yyyy') ");
            bComaPendiente = true;
        }
    	if (obj.getEjerDECAIncorporar()!=-1 && (obj.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA || obj.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_RECHAZADA) ){
            if (bComaPendiente){
                sb.append(", ");
            }
            sb.append(P06BTablas.P06B_P06B20_ULTEJERINCORPORADO + "=?");
            bComaPendiente = true;
    	}
	    if (obj.getDatosAtencionPeticionEnRevision()!=null && (obj.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA || obj.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_RECHAZADA) ){
            if (bComaPendiente){
                sb.append(", ");
            }
	        sb.append(P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA + "=?");
            bComaPendiente = true;
	    }
	    if (obj.getTipoAtencionCliente()!=null){
            if (bComaPendiente){
                sb.append(", ");
            }
            sb.append(P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE + "=?");
            bComaPendiente = true;
	    }
        sb.append(" WHERE " + P06BTablas.P06B_P06B20_NUMEXP + "=?");
        sql = sb.toString();

        try{
    		PreparedStatement lstm  = null;
            Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
            lstm = lconConexion.prepareStatement(sql);

    		int nDesfaseANumColTotal = 0;
            if (obj.getDatosAtencionPeticionEnRevision()==null || obj.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA){
            	lstm.setString(1,obj.getDni().toUpperCase());
            	lstm.setString(2,obj.getRazsoc().toUpperCase());
            	lstm.setString(3,obj.getNombre().toUpperCase());
            	lstm.setString(4,obj.getApe1().toUpperCase());
            	lstm.setString(5,obj.getApe2().toUpperCase());
        		if (obj.getDatosAtencionPeticionEnRevision()==null || obj.getDatosAtencionPeticionEnRevision().isbActualizarDomicilioSocial()){
        	    	lstm.setString(6,obj.getDomici().toUpperCase());
        	    	lstm.setString(7,obj.getCodmun().toUpperCase());
        	    	lstm.setString(8,obj.getLocali().toUpperCase());
        	    	lstm.setString(9,obj.getCodpro().toUpperCase());
        	    	lstm.setString(10,obj.getCodpst().toUpperCase());
        	    	lstm.setString(11,obj.getTelefot().toUpperCase());
        	    	lstm.setString(12,obj.getMail().toUpperCase());
        	    	lstm.setString(13,obj.getWeb().toUpperCase());
        		}else{
        			nDesfaseANumColTotal += 8;
        		}
            	lstm.setString(14-nDesfaseANumColTotal,obj.getTelefom().toUpperCase());
            	lstm.setString(15-nDesfaseANumColTotal,obj.getTelefoc().toUpperCase());
            	lstm.setString(16-nDesfaseANumColTotal,obj.getFax1().toUpperCase());
            	lstm.setString(17-nDesfaseANumColTotal,obj.getFax2().toUpperCase());
            	lstm.setString(18-nDesfaseANumColTotal,obj.getCurso().toUpperCase());
            	lstm.setString(19-nDesfaseANumColTotal,obj.getDenCurso().toUpperCase());
            	lstm.setString(20-nDesfaseANumColTotal,obj.getAcredita().toUpperCase());
            	lstm.setString(21-nDesfaseANumColTotal,obj.getDAcredita().toUpperCase());
            	lstm.setString(22-nDesfaseANumColTotal,obj.getEstado().toUpperCase());
            	lstm.setString(23-nDesfaseANumColTotal,obj.getFechaAl().toUpperCase());
            	lstm.setString(24-nDesfaseANumColTotal,obj.getFechaBaj().toUpperCase());
            	lstm.setString(25-nDesfaseANumColTotal,obj.getMotivoB().toUpperCase());
            	lstm.setString(26-nDesfaseANumColTotal,obj.getFechaSus().toUpperCase());
            	lstm.setString(27-nDesfaseANumColTotal,obj.getMotivoS().toUpperCase());
            	lstm.setString(28-nDesfaseANumColTotal,obj.getFecFinSu().toUpperCase());
        		if (obj.getDatosAtencionPeticionEnRevision()==null || obj.getDatosAtencionPeticionEnRevision().isbActualizarCapitalSocial()){
        	    	if(obj.getCapsoc().equals("")){
        	    		lstm.setString(29-nDesfaseANumColTotal,null);
        	    	}else{
        	    		lstm.setDouble(29-nDesfaseANumColTotal, Double.parseDouble(obj.getCapsoc()));
        	    	}
        	    	lstm.setString(30-nDesfaseANumColTotal,obj.getPaticipa().toUpperCase());
        		}else{
        			nDesfaseANumColTotal += 2;
        		}
            	lstm.setString(31-nDesfaseANumColTotal,obj.getDProFor().toUpperCase());
            	lstm.setString(32-nDesfaseANumColTotal,obj.getActIns().toUpperCase());
            	lstm.setString(33-nDesfaseANumColTotal,obj.getTrasdgs().toUpperCase());
    		}else{
    			nDesfaseANumColTotal += 33;
    		}
        	if (obj.getEjerDECAIncorporar()!=-1 && (obj.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA || obj.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_RECHAZADA) ){
                	lstm.setInt(34-nDesfaseANumColTotal,obj.getEjerDECAIncorporar());
        	}else{
        		nDesfaseANumColTotal += 1;
        	}
    	    if (obj.getDatosAtencionPeticionEnRevision()!=null && obj.getCorrelAtencionPeticionEnRevision()!=-1 && (obj.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_APROBADA || obj.getEstadoAceptarPropuestas()==P06BConstantes.P06B_AP_ESTADO_RECHAZADA) ){
    	    	lstm.setInt(35-nDesfaseANumColTotal,obj.getCorrelAtencionPeticionEnRevision());
        	}else{
        		nDesfaseANumColTotal += 1;
        	}

        	//la parte where de la update
    	    if (obj.getTipoAtencionCliente()!=null){
    	    	lstm.setString(36-nDesfaseANumColTotal,obj.getTipoAtencionCliente());
        	}else{
        		nDesfaseANumColTotal += 1;
        	}
        	lstm.setString(37-nDesfaseANumColTotal,obj.getExpedi().toUpperCase());
        	lstm.executeUpdate();
            lstm.close();
            lconConexion.close();
		}catch (SQLException e) {
	        P06BLog.send(2,this, "P06B20T00DAO-update Error: " + e.getMessage());
	        throw e;
		}
        P06BLog.send(2,this, "Fin P06B20T00DAO-update Devuelve: " + obj.getExpedi());
        return obj.getExpedi().toUpperCase();
	}

	/**
    * Obtiene un registro de la BD a partir del cdigo
    * @param codigoPK.
    *            clave primaria
    * @return un objeto P06B20T00Datatype o null si no se encuentra
    * nada.
	 * @throws Exception
    */
	public P06B20T00Datatype select(String codigoPK) throws Exception{
		P06BLog.send(2,this, "Inicio P06B20T00Datatype-select");
		P06B20T00Datatype result = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,codigoPK.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	result = new P06B20T00Datatype();
	        	result.setExpedi(lrst.getString(P06BTablas.P06B_P06B20_NUMEXP));
				result.setClase(lrst.getString(P06BTablas.P06B_P06B20_CLASE)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CLASE));
				result.setDni(lrst.getString(P06BTablas.P06B_P06B20_IDENTIFICADOR)==null?"":lrst.getString(P06BTablas.P06B_P06B20_IDENTIFICADOR));
				result.setRazsoc(lrst.getString(P06BTablas.P06B_P06B20_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_RAZSOC));
				result.setNombre(lrst.getString(P06BTablas.P06B_P06B20_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B20_NOMBRE));
				result.setApe1(lrst.getString(P06BTablas.P06B_P06B20_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B20_APE1));
				result.setApe2(lrst.getString(P06BTablas.P06B_P06B20_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B20_APE2));
				result.setDomici(lrst.getString(P06BTablas.P06B_P06B20_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DOMICI));
				result.setCodmun(lrst.getString(P06BTablas.P06B_P06B20_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODMUN));
				result.setLocali(lrst.getString(P06BTablas.P06B_P06B20_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_LOCALI));
				result.setCodpro(lrst.getString(P06BTablas.P06B_P06B20_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPRO));
				result.setCodpst(lrst.getString(P06BTablas.P06B_P06B20_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPST));
				result.setTelefot(lrst.getString(P06BTablas.P06B_P06B20_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOT));
				result.setTelefom(lrst.getString(P06BTablas.P06B_P06B20_TELEFOM)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOM));
				result.setTelefoc(lrst.getString(P06BTablas.P06B_P06B20_TELEFOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOC));
				result.setFax1(lrst.getString(P06BTablas.P06B_P06B20_FAX1)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX1));
				result.setFax2(lrst.getString(P06BTablas.P06B_P06B20_FAX2)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX2));
				result.setMail(lrst.getString(P06BTablas.P06B_P06B20_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MAIL));
				result.setWeb(lrst.getString(P06BTablas.P06B_P06B20_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_WEB));
				result.setCurso(lrst.getString(P06BTablas.P06B_P06B20_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CURSO));
				result.setDenCurso(lrst.getString(P06BTablas.P06B_P06B20_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DENCURSO));
				result.setAcredita(lrst.getString(P06BTablas.P06B_P06B20_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACREDITA));
				result.setDAcredita(lrst.getString(P06BTablas.P06B_P06B20_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DACREDITA));
				result.setEstado(lrst.getString(P06BTablas.P06B_P06B20_ESTADO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ESTADO));
				result.setFechaAl(lrst.getString(P06BTablas.P06B_P06B20_FECHAAL)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHAAL),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				result.setFechaBaj(lrst.getString(P06BTablas.P06B_P06B20_FECHABAJ)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHABAJ),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				result.setMotivoB(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB));
				result.setFechaSus(lrst.getString(P06BTablas.P06B_P06B20_FECHASUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHASUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				result.setMotivoS(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS));
				result.setFecFinSu(lrst.getString(P06BTablas.P06B_P06B20_FECFINSU)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECFINSU),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				result.setCapsoc(lrst.getString(P06BTablas.P06B_P06B20_CAPSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CAPSOC));
				result.setPaticipa(lrst.getString(P06BTablas.P06B_P06B20_PATICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_PATICIPA));
				result.setDProFor(lrst.getString(P06BTablas.P06B_P06B20_DPROFOR)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DPROFOR));
				result.setActIns(lrst.getString(P06BTablas.P06B_P06B20_ACTINS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACTINS));
				result.setTrasdgs(lrst.getString(P06BTablas.P06B_P06B20_TRASDGS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_TRASDGS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				result.setUltEjerIncorporado(lrst.getInt(P06BTablas.P06B_P06B20_ULTEJERINCORPORADO));
				result.setUltAtencPeticIncorporada(lrst.getInt(P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA));
				result.setTipoAtencionCliente(lrst.getString(P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE));
	        }
	        P06BLog.send(2,this, "Fin P06B20T00Datatype-select");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return result;
	}


	/**
    * Obtiene un registro de la BD a partir del cdigo
    * @param codigoPK.
    *            clave primaria
    * @return un objeto P06B20T00Datatype o null si no se encuentra
    * nada.
	 * @throws Exception
    */
	public P06B20T00Datatype selectIncorporacion(String expediente, int nEjerIncorporarDEC) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B20T00DAO-selectIncorporacion");
		P06B20T00Datatype obj20 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK_INCORPORACION;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,nEjerIncorporarDEC);
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	        	obj20 = new P06B20T00Datatype();

	        	//Mover campos 20
		    	obj20.setExpedi(expediente.toUpperCase());
				obj20.setClase(lrst.getString(P06BTablas.P06B_P06B20_CLASE)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CLASE));
				obj20.setDni(lrst.getString(P06BTablas.P06B_P06B20_IDENTIFICADOR)==null?"":lrst.getString(P06BTablas.P06B_P06B20_IDENTIFICADOR));
				obj20.setRazsoc(lrst.getString(P06BTablas.P06B_P06B20_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_RAZSOC));
				obj20.setNombre(lrst.getString(P06BTablas.P06B_P06B20_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B20_NOMBRE));
				obj20.setApe1(lrst.getString(P06BTablas.P06B_P06B20_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B20_APE1));
				obj20.setApe2(lrst.getString(P06BTablas.P06B_P06B20_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B20_APE2));
				obj20.setDomici(lrst.getString(P06BTablas.P06B_P06B20_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DOMICI));
				obj20.setCodmun(lrst.getString(P06BTablas.P06B_P06B20_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODMUN));
				obj20.setLocali(lrst.getString(P06BTablas.P06B_P06B20_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_LOCALI));
				obj20.setCodpro(lrst.getString(P06BTablas.P06B_P06B20_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPRO));
				obj20.setCodpst(lrst.getString(P06BTablas.P06B_P06B20_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPST));
				obj20.setTelefot(lrst.getString(P06BTablas.P06B_P06B20_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOT));
				obj20.setTelefom(lrst.getString(P06BTablas.P06B_P06B20_TELEFOM)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOM));
				obj20.setFax1(lrst.getString(P06BTablas.P06B_P06B20_FAX1)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX1));
				obj20.setMail(lrst.getString(P06BTablas.P06B_P06B20_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MAIL));
				obj20.setWeb(lrst.getString(P06BTablas.P06B_P06B20_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_WEB));
				obj20.setCapsoc(lrst.getString(P06BTablas.P06B_P06B20_CAPSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CAPSOC));

				obj20.setTelefoc(lrst.getString(P06BTablas.P06B_P06B20_TELEFOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOC));
				obj20.setFax2(lrst.getString(P06BTablas.P06B_P06B20_FAX2)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX2));
				obj20.setCurso(lrst.getString(P06BTablas.P06B_P06B20_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CURSO));
				obj20.setDenCurso(lrst.getString(P06BTablas.P06B_P06B20_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DENCURSO));
				obj20.setAcredita(lrst.getString(P06BTablas.P06B_P06B20_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACREDITA));
				obj20.setDAcredita(lrst.getString(P06BTablas.P06B_P06B20_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DACREDITA));
				obj20.setEstado(lrst.getString(P06BTablas.P06B_P06B20_ESTADO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ESTADO));
				obj20.setFechaAl(lrst.getString(P06BTablas.P06B_P06B20_FECHAAL)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHAAL),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				obj20.setFechaBaj(lrst.getString(P06BTablas.P06B_P06B20_FECHABAJ)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHABAJ),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				obj20.setMotivoB(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB));
				obj20.setFechaSus(lrst.getString(P06BTablas.P06B_P06B20_FECHASUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHASUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				obj20.setMotivoS(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS));
				obj20.setFecFinSu(lrst.getString(P06BTablas.P06B_P06B20_FECFINSU)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECFINSU),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				obj20.setPaticipa(lrst.getString(P06BTablas.P06B_P06B20_PATICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_PATICIPA));
				obj20.setDProFor(lrst.getString(P06BTablas.P06B_P06B20_DPROFOR)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DPROFOR));
				obj20.setActIns(lrst.getString(P06BTablas.P06B_P06B20_ACTINS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACTINS));
				obj20.setTrasdgs(lrst.getString(P06BTablas.P06B_P06B20_TRASDGS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_TRASDGS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				obj20.setUltEjerIncorporado(lrst.getInt(P06BTablas.P06B_P06B20_ULTEJERINCORPORADO));
				obj20.setUltAtencPeticIncorporada(lrst.getInt(P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA));
				obj20.setTipoAtencionCliente(lrst.getString(P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE));

	        	//Mover campos 32
	        	obj20.setExpedi(expediente.toUpperCase());
				obj20.setClase(lrst.getString(P06BTablas.P06B_P06B32_CLASE)==null?"":lrst.getString(P06BTablas.P06B_P06B32_CLASE));
				obj20.setDni(lrst.getString(P06BTablas.P06B_P06B32_IDENTIFICADOR)==null?"":lrst.getString(P06BTablas.P06B_P06B32_IDENTIFICADOR));
				obj20.setRazsoc(lrst.getString(P06BTablas.P06B_P06B32_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B32_RAZSOC));
				obj20.setNombre(lrst.getString(P06BTablas.P06B_P06B32_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B32_NOMBRE));
				obj20.setApe1(lrst.getString(P06BTablas.P06B_P06B32_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B32_APE1));
				obj20.setApe2(lrst.getString(P06BTablas.P06B_P06B32_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B32_APE2));
				obj20.setDomici(lrst.getString(P06BTablas.P06B_P06B32_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B32_DOMICI));
				obj20.setCodmun(lrst.getString(P06BTablas.P06B_P06B32_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B32_CODMUN));
				obj20.setLocali(lrst.getString(P06BTablas.P06B_P06B32_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B32_LOCALI));
				obj20.setCodpro(lrst.getString(P06BTablas.P06B_P06B32_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B32_CODPRO));
				obj20.setCodpst(lrst.getString(P06BTablas.P06B_P06B32_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B32_CODPST));
				obj20.setTelefot(lrst.getString(P06BTablas.P06B_P06B32_TELEFONO)==null?"":lrst.getString(P06BTablas.P06B_P06B32_TELEFONO));
				obj20.setTelefom(lrst.getString(P06BTablas.P06B_P06B32_MOVIL)==null?"":lrst.getString(P06BTablas.P06B_P06B32_MOVIL));
				obj20.setFax1(lrst.getString(P06BTablas.P06B_P06B32_FAX)==null?"":lrst.getString(P06BTablas.P06B_P06B32_FAX));
				obj20.setMail(lrst.getString(P06BTablas.P06B_P06B32_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B32_MAIL));
				obj20.setWeb(lrst.getString(P06BTablas.P06B_P06B32_DOMINIO_INTERNET)==null?"":lrst.getString(P06BTablas.P06B_P06B32_DOMINIO_INTERNET));
				obj20.setCapsoc(lrst.getString(P06BTablas.P06B_P06B32_CAPSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B32_CAPSOC));

//			    obj20.setAprobado(0);

	        	//Mover datos originales
		    	P06B20T00Datatype datos20Originales = new P06B20T00Datatype();
		    	datos20Originales.setExpedi(expediente.toUpperCase());
				datos20Originales.setClase(lrst.getString(P06BTablas.P06B_P06B20_CLASE)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CLASE));
				datos20Originales.setDni(lrst.getString(P06BTablas.P06B_P06B20_IDENTIFICADOR)==null?"":lrst.getString(P06BTablas.P06B_P06B20_IDENTIFICADOR));
				datos20Originales.setRazsoc(lrst.getString(P06BTablas.P06B_P06B20_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_RAZSOC));
				datos20Originales.setNombre(lrst.getString(P06BTablas.P06B_P06B20_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B20_NOMBRE));
				datos20Originales.setApe1(lrst.getString(P06BTablas.P06B_P06B20_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B20_APE1));
				datos20Originales.setApe2(lrst.getString(P06BTablas.P06B_P06B20_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B20_APE2));
				datos20Originales.setDomici(lrst.getString(P06BTablas.P06B_P06B20_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DOMICI));
				datos20Originales.setCodmun(lrst.getString(P06BTablas.P06B_P06B20_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODMUN));
				datos20Originales.setLocali(lrst.getString(P06BTablas.P06B_P06B20_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_LOCALI));
				datos20Originales.setCodpro(lrst.getString(P06BTablas.P06B_P06B20_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPRO));
				datos20Originales.setCodpst(lrst.getString(P06BTablas.P06B_P06B20_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPST));
				datos20Originales.setTelefot(lrst.getString(P06BTablas.P06B_P06B20_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOT));
				datos20Originales.setTelefom(lrst.getString(P06BTablas.P06B_P06B20_TELEFOM)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOM));
				datos20Originales.setFax1(lrst.getString(P06BTablas.P06B_P06B20_FAX1)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX1));
				datos20Originales.setMail(lrst.getString(P06BTablas.P06B_P06B20_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MAIL));
				datos20Originales.setWeb(lrst.getString(P06BTablas.P06B_P06B20_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_WEB));
				datos20Originales.setCapsoc(lrst.getString(P06BTablas.P06B_P06B20_CAPSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CAPSOC));

				datos20Originales.setTelefoc(lrst.getString(P06BTablas.P06B_P06B20_TELEFOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOC));
				datos20Originales.setFax2(lrst.getString(P06BTablas.P06B_P06B20_FAX2)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX2));
				datos20Originales.setCurso(lrst.getString(P06BTablas.P06B_P06B20_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CURSO));
				datos20Originales.setDenCurso(lrst.getString(P06BTablas.P06B_P06B20_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DENCURSO));
				datos20Originales.setAcredita(lrst.getString(P06BTablas.P06B_P06B20_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACREDITA));
				datos20Originales.setDAcredita(lrst.getString(P06BTablas.P06B_P06B20_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DACREDITA));
				datos20Originales.setEstado(lrst.getString(P06BTablas.P06B_P06B20_ESTADO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ESTADO));
				datos20Originales.setFechaAl(lrst.getString(P06BTablas.P06B_P06B20_FECHAAL)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHAAL),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				datos20Originales.setFechaBaj(lrst.getString(P06BTablas.P06B_P06B20_FECHABAJ)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHABAJ),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				datos20Originales.setMotivoB(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB));
				datos20Originales.setFechaSus(lrst.getString(P06BTablas.P06B_P06B20_FECHASUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHASUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				datos20Originales.setMotivoS(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS));
				datos20Originales.setFecFinSu(lrst.getString(P06BTablas.P06B_P06B20_FECFINSU)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECFINSU),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				datos20Originales.setPaticipa(lrst.getString(P06BTablas.P06B_P06B20_PATICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_PATICIPA));
				datos20Originales.setDProFor(lrst.getString(P06BTablas.P06B_P06B20_DPROFOR)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DPROFOR));
				datos20Originales.setActIns(lrst.getString(P06BTablas.P06B_P06B20_ACTINS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACTINS));
				datos20Originales.setTrasdgs(lrst.getString(P06BTablas.P06B_P06B20_TRASDGS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_TRASDGS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				datos20Originales.setUltEjerIncorporado(lrst.getInt(P06BTablas.P06B_P06B20_ULTEJERINCORPORADO));
				datos20Originales.setUltAtencPeticIncorporada(lrst.getInt(P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA));
				datos20Originales.setTipoAtencionCliente(lrst.getString(P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE));
		    	datos20Originales.setDatos20Originales(datos20Originales);

		    	obj20.setDatos20Originales(datos20Originales);
	        }
	        P06BLog.send(2,this, "Fin P06B20T00DAO-selectIncorporacion");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return obj20;
	}


	/**
    * Obtiene un registro de la BD a partir del cdigo
    * @param codigoPK.
    *            clave primaria
    * @return un objeto P06B20T00Datatype o null si no se encuentra
    * nada.
	 * @throws Exception
    */
	public P06B20T00Datatype selectCorredorCorrelAtencionPeticionEnRevision(String expediente, P06B64T00Datatype p06B64T00Datatype) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B20T00DAO-selectCorredorCorrelAtencionPeticionEnRevision");
		P06B20T00Datatype obj20 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK_CORRELATENCIONPETICIONENREVISION;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,p06B64T00Datatype.getCorrelativo());
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	        	obj20 = new P06B20T00Datatype();
		    	P06B20T00Datatype datos20Originales = new P06B20T00Datatype();

		    	//Mover dato original a datos20Originales y dato propuesto a obj20

		    	//Datos en ambos
		    	datos20Originales.setExpedi(expediente.toUpperCase());
	        	obj20.setExpedi(expediente.toUpperCase());

	        	datos20Originales.setClase(lrst.getString(P06BTablas.P06B_P06B20_CLASE)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CLASE));
	        	obj20.setClase(lrst.getString(P06BTablas.P06B_P06B70_CO_CLASE)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_CLASE));

	        	datos20Originales.setDni(lrst.getString(P06BTablas.P06B_P06B20_IDENTIFICADOR)==null?"":lrst.getString(P06BTablas.P06B_P06B20_IDENTIFICADOR));
	        	obj20.setDni(lrst.getString(P06BTablas.P06B_P06B70_CO_IDENTIFICADOR)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_IDENTIFICADOR));

	        	datos20Originales.setRazsoc(lrst.getString(P06BTablas.P06B_P06B20_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_RAZSOC));
	        	obj20.setRazsoc(lrst.getString(P06BTablas.P06B_P06B70_CO_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_RAZSOC));

	        	datos20Originales.setNombre(lrst.getString(P06BTablas.P06B_P06B20_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B20_NOMBRE));
	        	obj20.setNombre(lrst.getString(P06BTablas.P06B_P06B70_CO_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_NOMBRE));

	        	datos20Originales.setApe1(lrst.getString(P06BTablas.P06B_P06B20_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B20_APE1));
	        	obj20.setApe1(lrst.getString(P06BTablas.P06B_P06B70_CO_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_APE1));

	        	datos20Originales.setApe2(lrst.getString(P06BTablas.P06B_P06B20_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B20_APE2));
	        	obj20.setApe2(lrst.getString(P06BTablas.P06B_P06B70_CO_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_APE2));

	        	datos20Originales.setDomici(lrst.getString(P06BTablas.P06B_P06B20_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DOMICI));
	        	if (p06B64T00Datatype.isbActualizarDomicilioSocial()){
		        	obj20.setDomici(lrst.getString(P06BTablas.P06B_P06B70_CO_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_DOMICI));
	        	}else{
	        		obj20.setDomici(lrst.getString(P06BTablas.P06B_P06B20_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DOMICI));
	        	}

	        	datos20Originales.setCodpro(lrst.getString(P06BTablas.P06B_P06B20_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPRO));
	        	if (p06B64T00Datatype.isbActualizarDomicilioSocial()){
		        	obj20.setCodpro(lrst.getString(P06BTablas.P06B_P06B70_CO_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_CODPRO));
	        	}else{
	        		obj20.setCodpro(lrst.getString(P06BTablas.P06B_P06B20_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPRO));
	        	}

	        	datos20Originales.setCodmun(lrst.getString(P06BTablas.P06B_P06B20_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODMUN));
	        	if (p06B64T00Datatype.isbActualizarDomicilioSocial()){
		        	obj20.setCodmun(lrst.getString(P06BTablas.P06B_P06B70_CO_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_CODMUN));
	        	}else{
	        		obj20.setCodmun(lrst.getString(P06BTablas.P06B_P06B20_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODMUN));
	        	}

	        	datos20Originales.setCodpst(lrst.getString(P06BTablas.P06B_P06B20_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPST));
	        	if (p06B64T00Datatype.isbActualizarDomicilioSocial()){
		        	obj20.setCodpst(lrst.getString(P06BTablas.P06B_P06B70_CO_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_CODPST));
	        	}else{
	        		obj20.setCodpst(lrst.getString(P06BTablas.P06B_P06B20_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPST));
	        	}

	        	datos20Originales.setTelefot(lrst.getString(P06BTablas.P06B_P06B20_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOT));
	        	if (p06B64T00Datatype.isbActualizarDomicilioSocial()){
	        		if (lrst.getString(P06BTablas.P06B_P06B70_CO_TELEFONO)==null || "".equals(lrst.getString(P06BTablas.P06B_P06B70_CO_TELEFONO).trim())){
		        		obj20.setTelefot(lrst.getString(P06BTablas.P06B_P06B20_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOT));
	        		}else{
			        	obj20.setTelefot(lrst.getString(P06BTablas.P06B_P06B70_CO_TELEFONO)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_TELEFONO));
	        		}
	        	}else{
	        		obj20.setTelefot(lrst.getString(P06BTablas.P06B_P06B20_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOT));
	        	}

	        	datos20Originales.setMail(lrst.getString(P06BTablas.P06B_P06B20_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MAIL));
	        	if (p06B64T00Datatype.isbActualizarDomicilioSocial()){
	        		if (lrst.getString(P06BTablas.P06B_P06B70_CO_MAIL)==null || "".equals(lrst.getString(P06BTablas.P06B_P06B70_CO_MAIL).trim())){
		        		obj20.setMail(lrst.getString(P06BTablas.P06B_P06B20_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MAIL));
	        		}else{
			        	obj20.setMail(lrst.getString(P06BTablas.P06B_P06B70_CO_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_MAIL));
	        		}
	        	}else{
	        		obj20.setMail(lrst.getString(P06BTablas.P06B_P06B20_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MAIL));
	        	}

	        	datos20Originales.setWeb(lrst.getString(P06BTablas.P06B_P06B20_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_WEB));
	        	if (p06B64T00Datatype.isbActualizarDomicilioSocial()){
	        		if (lrst.getString(P06BTablas.P06B_P06B70_CO_WEB)==null || "".equals(lrst.getString(P06BTablas.P06B_P06B70_CO_WEB).trim())){
		        		obj20.setWeb(lrst.getString(P06BTablas.P06B_P06B20_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_WEB));
	        		}else{
			        	obj20.setWeb(lrst.getString(P06BTablas.P06B_P06B70_CO_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_WEB));
	        		}
	        	}else{
	        		obj20.setWeb(lrst.getString(P06BTablas.P06B_P06B20_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_WEB));
	        	}

	        	datos20Originales.setCapsoc(lrst.getString(P06BTablas.P06B_P06B20_CAPSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CAPSOC));
	        	if (p06B64T00Datatype.isbActualizarCapitalSocial()){
	        		if (lrst.getString(P06BTablas.P06B_P06B70_CO_CAPSOC)==null || "".equals(lrst.getString(P06BTablas.P06B_P06B70_CO_CAPSOC).trim())){
		        		obj20.setCapsoc(lrst.getString(P06BTablas.P06B_P06B20_CAPSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CAPSOC));
	        		}else{
			        	obj20.setCapsoc(lrst.getString(P06BTablas.P06B_P06B70_CO_CAPSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_CAPSOC));
	        		}
	        	}else{
	        		obj20.setCapsoc(lrst.getString(P06BTablas.P06B_P06B20_CAPSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CAPSOC));
	        	}

	        	datos20Originales.setPaticipa(lrst.getString(P06BTablas.P06B_P06B20_PATICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_PATICIPA));
	        	if (p06B64T00Datatype.isbActualizarCapitalSocial()){
	        		if (lrst.getString(P06BTablas.P06B_P06B70_CO_PATICIPA)==null || "".equals(lrst.getString(P06BTablas.P06B_P06B70_CO_PATICIPA).trim())){
		        		obj20.setPaticipa(lrst.getString(P06BTablas.P06B_P06B20_PATICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_PATICIPA));
	        		}else{
		        		obj20.setPaticipa(lrst.getString(P06BTablas.P06B_P06B70_CO_PATICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B70_CO_PATICIPA));
	        		}
	        	}else{
	        		obj20.setPaticipa(lrst.getString(P06BTablas.P06B_P06B20_PATICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_PATICIPA));
	        	}
	        	datos20Originales.setTipoAtencionCliente(lrst.getString(P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE));
	        	if (p06B64T00Datatype.isbActualizarAtencionDefensaCliente()){
	        		obj20.setTipoAtencionCliente(lrst.getString(P06BTablas.P06B_P06B70_CO_TIPOATENCIONCLIENTE));
	        	}else{
	        		obj20.setTipoAtencionCliente(lrst.getString(P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE));
	        	}

		    	//Datos solo en original
	        	datos20Originales.setLocali(lrst.getString(P06BTablas.P06B_P06B20_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_LOCALI));
	        	if (obj20.getCodpro().equals(lrst.getString(P06BTablas.P06B_P06B20_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPRO)) &&
	        			obj20.getCodmun().equals(lrst.getString(P06BTablas.P06B_P06B20_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODMUN))){
	        		obj20.setLocali(lrst.getString(P06BTablas.P06B_P06B20_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_LOCALI));
	        	}else{
	        		obj20.setLocali("");
	        	}

	        	datos20Originales.setTelefom(lrst.getString(P06BTablas.P06B_P06B20_TELEFOM)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOM));
	        	obj20.setTelefom(lrst.getString(P06BTablas.P06B_P06B20_TELEFOM)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOM));

	        	datos20Originales.setTelefoc(lrst.getString(P06BTablas.P06B_P06B20_TELEFOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOC));
	        	obj20.setTelefoc(lrst.getString(P06BTablas.P06B_P06B20_TELEFOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOC));

	        	datos20Originales.setFax1(lrst.getString(P06BTablas.P06B_P06B20_FAX1)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX1));
	        	obj20.setFax1(lrst.getString(P06BTablas.P06B_P06B20_FAX1)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX1));

	        	datos20Originales.setFax2(lrst.getString(P06BTablas.P06B_P06B20_FAX2)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX2));
	        	obj20.setFax2(lrst.getString(P06BTablas.P06B_P06B20_FAX2)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX2));

	        	datos20Originales.setCurso(lrst.getString(P06BTablas.P06B_P06B20_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CURSO));
	        	obj20.setCurso(lrst.getString(P06BTablas.P06B_P06B20_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CURSO));

	        	datos20Originales.setDenCurso(lrst.getString(P06BTablas.P06B_P06B20_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DENCURSO));
	        	obj20.setDenCurso(lrst.getString(P06BTablas.P06B_P06B20_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DENCURSO));

	        	datos20Originales.setAcredita(lrst.getString(P06BTablas.P06B_P06B20_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACREDITA));
	        	obj20.setAcredita(lrst.getString(P06BTablas.P06B_P06B20_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACREDITA));

	        	datos20Originales.setDAcredita(lrst.getString(P06BTablas.P06B_P06B20_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DACREDITA));
	        	obj20.setDAcredita(lrst.getString(P06BTablas.P06B_P06B20_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DACREDITA));

	        	datos20Originales.setEstado(lrst.getString(P06BTablas.P06B_P06B20_ESTADO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ESTADO));
	        	obj20.setEstado(lrst.getString(P06BTablas.P06B_P06B20_ESTADO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ESTADO));

	        	datos20Originales.setFechaAl(lrst.getString(P06BTablas.P06B_P06B20_FECHAAL)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHAAL),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        	obj20.setFechaAl(lrst.getString(P06BTablas.P06B_P06B20_FECHAAL)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHAAL),new Locale(P06BConstantes.P06B_IDIOMA_ES)));

	        	datos20Originales.setFechaBaj(lrst.getString(P06BTablas.P06B_P06B20_FECHABAJ)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHABAJ),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        	obj20.setFechaBaj(lrst.getString(P06BTablas.P06B_P06B20_FECHABAJ)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHABAJ),new Locale(P06BConstantes.P06B_IDIOMA_ES)));

	        	datos20Originales.setMotivoB(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB));
	        	obj20.setMotivoB(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB));

	        	datos20Originales.setFechaSus(lrst.getString(P06BTablas.P06B_P06B20_FECHASUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHASUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        	obj20.setFechaSus(lrst.getString(P06BTablas.P06B_P06B20_FECHASUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHASUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));

	        	datos20Originales.setMotivoS(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS));
	        	obj20.setMotivoS(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS));

	        	datos20Originales.setFecFinSu(lrst.getString(P06BTablas.P06B_P06B20_FECFINSU)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECFINSU),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        	obj20.setFecFinSu(lrst.getString(P06BTablas.P06B_P06B20_FECFINSU)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECFINSU),new Locale(P06BConstantes.P06B_IDIOMA_ES)));

	        	datos20Originales.setDProFor(lrst.getString(P06BTablas.P06B_P06B20_DPROFOR)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DPROFOR));
	        	obj20.setDProFor(lrst.getString(P06BTablas.P06B_P06B20_DPROFOR)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DPROFOR));

	        	datos20Originales.setActIns(lrst.getString(P06BTablas.P06B_P06B20_ACTINS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACTINS));
	        	obj20.setActIns(lrst.getString(P06BTablas.P06B_P06B20_ACTINS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACTINS));

	        	datos20Originales.setTrasdgs(lrst.getString(P06BTablas.P06B_P06B20_TRASDGS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_TRASDGS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        	obj20.setTrasdgs(lrst.getString(P06BTablas.P06B_P06B20_TRASDGS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_TRASDGS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));

	        	datos20Originales.setUltEjerIncorporado(lrst.getInt(P06BTablas.P06B_P06B20_ULTEJERINCORPORADO));
	        	obj20.setUltEjerIncorporado(lrst.getInt(P06BTablas.P06B_P06B20_ULTEJERINCORPORADO));

	        	datos20Originales.setUltAtencPeticIncorporada(lrst.getInt(P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA));
	        	obj20.setUltAtencPeticIncorporada(lrst.getInt(P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA));

	        	//Dato duplicado?
				obj20.setCorrelAtencionPeticionEnRevision(p06B64T00Datatype.getCorrelativo());

//			    obj20.setAprobado(0);

		    	obj20.setDatos20Originales(datos20Originales);
	        }
	        P06BLog.send(2,this, "Fin P06B20T00DAO-selectCorredorCorrelAtencionPeticionEnRevision");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return obj20;
	}


	/**
    * Obtiene el Estado de un registro de la BD a partir del cdigo
    * @param codigoPK.
    *            clave primaria
    * @return String o vacio si no se encuentra
    * nada.
	 * @throws Exception
    */
	public String selectEstado(String codigoPK) throws Exception{
		P06BLog.send(2,this, "Inicio P06B20T00Datatype-selectEstado");
		String estado = "";
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_ESTADO_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,codigoPK.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	estado = lrst.getString(P06BTablas.P06B_P06B20_ESTADO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ESTADO);
	        }
	        P06BLog.send(2,this, "Fin P06B20T00Datatype-selectEstado");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return estado;
	}


	/**
    * Obtiene el Estado de un registro de la BD a partir del cdigo
    * @param codigoPK.
    *            clave primaria
    * @return String o vacio si no se encuentra
    * nada.
	 * @throws Exception
    */
	public int selectAtencPeticIncorporada(String codigoPK) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B20T00Datatype-selectAtencPeticIncorporada");
		int atencPeticIncorporada = 0;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_ATENCPETICINCORPORADA_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,codigoPK.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	atencPeticIncorporada = lrst.getInt(P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA);
	        }
	        P06BLog.send(2,this, "Fin P06B20T00Datatype-selectAtencPeticIncorporada");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return atencPeticIncorporada;
	}


	public String getStrListadoCorredores(String where){
		return SELECT_LISTADO + " " + where + " ORDER BY " + P06BTablas.P06B_P06B20_NUMEXP;
	}


	/**
    * Obtiene la lista de corredores que cumplen los criterios de bsqueda
    * @param whereCorredores: parte where de la select con los criterios de bsqueda
    * @return Lista de objetos corredores
	* @throws Exception
    */
	public ArrayList selectCorredoresListadoBusqueda(String whereCorredores) throws Exception{
		P06BLog.send(2,this, "Inicio P06B20T00DAO-selectCorredoresListadoBusqueda");
		ArrayList lista = new ArrayList();
		P06B20T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = "SELECT * FROM " + P06BTablas.P06B_P06B20T00_TABLA + " " + whereCorredores + " ORDER BY " + P06BTablas.P06B_P06B20_NUMEXP;
		P06BLog.send(2,this, "P06B20T00DAO-selectCorredoresListadoBusqueda: select para el listado : "+sql);
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	        	obj = new P06B20T00Datatype();
			    obj.setExpedi(lrst.getString(P06BTablas.P06B_P06B20_NUMEXP));
			    obj.setClase(lrst.getString(P06BTablas.P06B_P06B20_CLASE)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CLASE));
			    obj.setDni(lrst.getString(P06BTablas.P06B_P06B20_IDENTIFICADOR)==null?"":lrst.getString(P06BTablas.P06B_P06B20_IDENTIFICADOR));
			    obj.setRazsoc(lrst.getString(P06BTablas.P06B_P06B20_RAZSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_RAZSOC));
			    obj.setNombre(lrst.getString(P06BTablas.P06B_P06B20_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B20_NOMBRE));
			    obj.setApe1(lrst.getString(P06BTablas.P06B_P06B20_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B20_APE1));
			    obj.setApe2(lrst.getString(P06BTablas.P06B_P06B20_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B20_APE2));
			    obj.setDomici(lrst.getString(P06BTablas.P06B_P06B20_DOMICI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DOMICI));
			    obj.setCodmun(lrst.getString(P06BTablas.P06B_P06B20_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODMUN));
			    obj.setLocali(lrst.getString(P06BTablas.P06B_P06B20_LOCALI)==null?"":lrst.getString(P06BTablas.P06B_P06B20_LOCALI));
			    obj.setCodpro(lrst.getString(P06BTablas.P06B_P06B20_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPRO));
			    obj.setCodpst(lrst.getString(P06BTablas.P06B_P06B20_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CODPST));
			    obj.setTelefot(lrst.getString(P06BTablas.P06B_P06B20_TELEFOT)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOT));
			    obj.setTelefom(lrst.getString(P06BTablas.P06B_P06B20_TELEFOM)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOM));
			    obj.setTelefoc(lrst.getString(P06BTablas.P06B_P06B20_TELEFOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_TELEFOC));
			    obj.setFax1(lrst.getString(P06BTablas.P06B_P06B20_FAX1)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX1));
			    obj.setFax2(lrst.getString(P06BTablas.P06B_P06B20_FAX2)==null?"":lrst.getString(P06BTablas.P06B_P06B20_FAX2));
			    obj.setMail(lrst.getString(P06BTablas.P06B_P06B20_MAIL)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MAIL));
			    obj.setWeb(lrst.getString(P06BTablas.P06B_P06B20_WEB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_WEB));
				obj.setCurso(lrst.getString(P06BTablas.P06B_P06B20_CURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CURSO));
				obj.setDenCurso(lrst.getString(P06BTablas.P06B_P06B20_DENCURSO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DENCURSO));
				obj.setAcredita(lrst.getString(P06BTablas.P06B_P06B20_ACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACREDITA));
				obj.setDAcredita(lrst.getString(P06BTablas.P06B_P06B20_DACREDITA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DACREDITA));
				obj.setEstado(lrst.getString(P06BTablas.P06B_P06B20_ESTADO)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ESTADO));
				obj.setFechaAl(lrst.getString(P06BTablas.P06B_P06B20_FECHAAL)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHAAL),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				obj.setFechaBaj(lrst.getString(P06BTablas.P06B_P06B20_FECHABAJ)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHABAJ),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				obj.setMotivoB(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOB));
				obj.setFechaSus(lrst.getString(P06BTablas.P06B_P06B20_FECHASUS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECHASUS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				obj.setMotivoS(lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_MOTIVOS));
				obj.setFecFinSu(lrst.getString(P06BTablas.P06B_P06B20_FECFINSU)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_FECFINSU),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				obj.setCapsoc(lrst.getString(P06BTablas.P06B_P06B20_CAPSOC)==null?"":lrst.getString(P06BTablas.P06B_P06B20_CAPSOC));
				obj.setPaticipa(lrst.getString(P06BTablas.P06B_P06B20_PATICIPA)==null?"":lrst.getString(P06BTablas.P06B_P06B20_PATICIPA));
				obj.setDProFor(lrst.getString(P06BTablas.P06B_P06B20_DPROFOR)==null?"":lrst.getString(P06BTablas.P06B_P06B20_DPROFOR));
				obj.setActIns(lrst.getString(P06BTablas.P06B_P06B20_ACTINS)==null?"":lrst.getString(P06BTablas.P06B_P06B20_ACTINS));
				obj.setTrasdgs(lrst.getString(P06BTablas.P06B_P06B20_TRASDGS)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B20_TRASDGS),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				obj.setUltEjerIncorporado(lrst.getInt(P06BTablas.P06B_P06B20_ULTEJERINCORPORADO));
				obj.setUltAtencPeticIncorporada(lrst.getInt(P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA));

	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B20T00DAO-selectCorredoresListadoBusqueda");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return lista;
	}

	/**
    * Obtiene el objeto asociado a los parametros de entrada
    * @return objeto que cumple los parametros, o null si no lo encuentra
	 * @throws SQLException
	* @throws Exception
    */
	public ArrayList<P06B20T00Datatype> selectInformeComunicarDGSFP2() throws SQLException{
		P06BLog.send(2,this, "Inicio P06B20T00Datatype-selectInformeComunicarDGSFP2");
		ArrayList<P06B20T00Datatype> informeComunicarDGSFP2PDF = new ArrayList<P06B20T00Datatype>();
		P06B20T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_LISTADO2;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lrst = lstm.executeQuery();
            int indLinea = 0;
	        while(lrst.next()) {
	        	obj = new P06B20T00Datatype();
	        	obj.setExpedi(lrst.getString(1));
	        	obj.setFechaAl(lrst.getString(2));
	        	obj.setFechaBaj(lrst.getString(3));
	        	obj.setDni(lrst.getString(4));
	        	obj.setNombre(lrst.getString(5));
	        	obj.setClase(lrst.getString(6));
	        	obj.setDomici(lrst.getString(7));
	        	obj.setCodpst(lrst.getString(8));
	        	obj.setCodpro(lrst.getString(9));
	        	obj.setCodmun(lrst.getString(10));
	        	obj.setWeb(lrst.getString(11));
	        	informeComunicarDGSFP2PDF.add(indLinea, obj);
        		indLinea++;
	        }
	        P06BLog.send(2,this, "Fin P06B64T00Datatype-selectInformeComunicarDGSFP2");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	        throw e;
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return informeComunicarDGSFP2PDF;
	}



	/**
	 * INICIO
	 * Parte para la tabla P06B21T00 - estrechamente relacionada con la 20.
	 *
	 * **/




	/**
	 *
	 * Mtodo que calcula el numero de expediente para el tipo de persona que le corresponde
	 * @throws SQLException
	 *
	 * */
	private String calcularSteExp(Connection lconConexion, String tipoPersona) throws SQLException{
		//El formato del numero de expediente definitivamente es: {tipo}-{correlativo}EUS
		//tipo:AF,F,RF,AJ,J,RJ,OV
		//correlativo: un numero a nivel global, NOOOOO VA POR TIPO
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_MAXEXPEDI;
        String result = "";
        String maxVal = "";
        int numCerosInsertar = 0;
        String cte_eus = P06BConstantes.P06B_CORREDORES_CTEEXP_EUS;
        lstm = lconConexion.prepareStatement(sql);

        //En el parmetro "tipoPersona" ya viene el tipo como letra: AF,F,RF,AJ,J,RJ,OV. NOOOO un numero como venia antes.
        lrst = lstm.executeQuery();
    	if (lrst.next()) {
    		if(lrst.getString(1)!=null){
	    		maxVal = (new Long(lrst.getString(1)).longValue()+1)+"";
	    		numCerosInsertar = P06BConstantes.P06B_NUMPOSICIONES_CLAVE - maxVal.length();
	    		for (int i=0;i<numCerosInsertar;i++){
	    			maxVal = "0" + maxVal;
	    		}
	    		result =  tipoPersona + "-" + maxVal + cte_eus;
    		}else{
    			maxVal = "1";
    			numCerosInsertar = P06BConstantes.P06B_NUMPOSICIONES_CLAVE - maxVal.length();
	    		for (int i=0;i<numCerosInsertar;i++){
	    			maxVal = "0" + maxVal;
	    		}
    			result =  tipoPersona + "-" + maxVal + cte_eus;
    		}
    	}
    	//A continuacin debo insertar el nuevo valor en la tabla gestora de expedientes
    	this.insertaExp(lconConexion,maxVal,tipoPersona);
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
		return result;
	}

	/**
    * Inserta un expediente a la tabla de gestin expedientes (21)
    * @param Conexion
    * @param Numero expediente
    * @param Ao del expediente
    * @param Tipo (fsica o jurdica)
    *
    * @throws SQLException
    */
	public void insertaExp(Connection lconConexion, String num, String tipo) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B20T00DAO/21-insertaExp");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = INSERT_NUEVO_EXP;
        lstm = lconConexion.prepareStatement(sql);

    	lstm.setString(1,tipo);
    	lstm.setString(2,num);

    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}

        P06BLog.send(2,this, "Fin P06B20T00DAO/21-insertaExp");
	}


	private static String SELECT_MAXEXPEDI =
		"SELECT MAX(" + P06BTablas.P06B_P06B21_NUMEXP + ") FROM "+ P06BTablas.P06B_P06B21T00_TABLA;


	private static String INSERT_NUEVO_EXP =
		"INSERT INTO "+ P06BTablas.P06B_P06B21T00_TABLA +
		"("+
		P06BTablas.P06B_P06B21_TIPOEXP + "," +
		P06BTablas.P06B_P06B21_NUMEXP+
		")"+
		" VALUES(?,TO_NUMBER(?))";



	/**
	 * FIN
	 * Parte para la tabla P06B21T00 - estrechamente relacionada con la 20.
	 *
	 * **/


	private static String INSERT_COMPLETA =
		"INSERT INTO "+ P06BTablas.P06B_P06B20T00_TABLA +
		" ("+
		P06BTablas.P06B_P06B20_NUMEXP + "," +
		P06BTablas.P06B_P06B20_CLASE + "," +
		P06BTablas.P06B_P06B20_IDENTIFICADOR + "," +
		P06BTablas.P06B_P06B20_RAZSOC + "," +
		P06BTablas.P06B_P06B20_NOMBRE + "," +
		P06BTablas.P06B_P06B20_APE1 + "," +
		P06BTablas.P06B_P06B20_APE2 + "," +
		P06BTablas.P06B_P06B20_DOMICI + "," +
		P06BTablas.P06B_P06B20_CODMUN + "," +
		P06BTablas.P06B_P06B20_LOCALI + "," +
		P06BTablas.P06B_P06B20_CODPRO + "," +
		P06BTablas.P06B_P06B20_CODPST + "," +
		P06BTablas.P06B_P06B20_TELEFOT + "," +
		P06BTablas.P06B_P06B20_TELEFOM + "," +
		P06BTablas.P06B_P06B20_TELEFOC + "," +
		P06BTablas.P06B_P06B20_FAX1 + "," +
		P06BTablas.P06B_P06B20_FAX2 + "," +
		P06BTablas.P06B_P06B20_MAIL + "," +
		P06BTablas.P06B_P06B20_WEB + "," +
		P06BTablas.P06B_P06B20_CURSO + "," +
		P06BTablas.P06B_P06B20_DENCURSO + "," +
		P06BTablas.P06B_P06B20_ACREDITA + "," +
		P06BTablas.P06B_P06B20_DACREDITA + "," +
		P06BTablas.P06B_P06B20_ESTADO + "," +
		P06BTablas.P06B_P06B20_FECHAAL + "," +
		P06BTablas.P06B_P06B20_FECHABAJ + "," +
		P06BTablas.P06B_P06B20_MOTIVOB + "," +
		P06BTablas.P06B_P06B20_FECHASUS + "," +
		P06BTablas.P06B_P06B20_MOTIVOS + "," +
		P06BTablas.P06B_P06B20_FECFINSU + "," +
		P06BTablas.P06B_P06B20_CAPSOC + "," +
		P06BTablas.P06B_P06B20_PATICIPA + "," +
		P06BTablas.P06B_P06B20_DPROFOR + "," +
		P06BTablas.P06B_P06B20_ACTINS + "," +
		P06BTablas.P06B_P06B20_TRASDGS + "," +
		P06BTablas.P06B_P06B20_ULTEJERINCORPORADO + "," +
		P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA +
		")"+
		" VALUES(?,?,?,?,?,?,?,?,TO_NUMBER(?),TO_NUMBER(?),TO_NUMBER(?)," +
		"?,?,?,?,?,?,?,?,?,?,?,?,?,TO_DATE(?,'dd/MM/yyyy')," +
		"TO_DATE(?,'dd/MM/yyyy'),?,TO_DATE(?,'dd/MM/yyyy'),?," +
		"TO_DATE(?,'dd/MM/yyyy'),?,TO_NUMBER(?),?,?,TO_DATE(?,'dd/MM/yyyy'),?,?)";

	private static String UPDATE_COMPLETA =
		"UPDATE  "+ P06BTablas.P06B_P06B20T00_TABLA + " SET " +
		P06BTablas.P06B_P06B20_IDENTIFICADOR + "=?, " +
		P06BTablas.P06B_P06B20_RAZSOC + "=?, " +
		P06BTablas.P06B_P06B20_NOMBRE + "=?, " +
		P06BTablas.P06B_P06B20_APE1 + "=?, " +
		P06BTablas.P06B_P06B20_APE2 + "=?, " +
		P06BTablas.P06B_P06B20_DOMICI + "=?, " +
		P06BTablas.P06B_P06B20_CODMUN + "= TO_NUMBER(?), " +
		P06BTablas.P06B_P06B20_LOCALI + "= TO_NUMBER(?), " +
		P06BTablas.P06B_P06B20_CODPRO + "= TO_NUMBER(?), " +
		P06BTablas.P06B_P06B20_CODPST + "=?, " +
		P06BTablas.P06B_P06B20_TELEFOT + "=?, " +
		P06BTablas.P06B_P06B20_TELEFOM + "=?, " +
		P06BTablas.P06B_P06B20_TELEFOC + "=?, " +
		P06BTablas.P06B_P06B20_FAX1 + "=?, " +
		P06BTablas.P06B_P06B20_FAX2 + "=?, " +
		P06BTablas.P06B_P06B20_MAIL + "=?, " +
		P06BTablas.P06B_P06B20_WEB + "=?, " +
		P06BTablas.P06B_P06B20_CURSO + "=?, " +
		P06BTablas.P06B_P06B20_DENCURSO + "=?, " +
		P06BTablas.P06B_P06B20_ACREDITA + "=?, " +
		P06BTablas.P06B_P06B20_DACREDITA + "=?, " +
		P06BTablas.P06B_P06B20_ESTADO + "=?, " +
		P06BTablas.P06B_P06B20_FECHAAL + "= TO_DATE(?,'dd/MM/yyyy'), " +
		P06BTablas.P06B_P06B20_FECHABAJ + "= TO_DATE(?,'dd/MM/yyyy'), " +
		P06BTablas.P06B_P06B20_MOTIVOB + "=?, " +
		P06BTablas.P06B_P06B20_FECHASUS + "= TO_DATE(?,'dd/MM/yyyy'), " +
		P06BTablas.P06B_P06B20_MOTIVOS + "=?, " +
		P06BTablas.P06B_P06B20_FECFINSU + "= TO_DATE(?,'dd/MM/yyyy'), " +
		P06BTablas.P06B_P06B20_CAPSOC + "=?, " +
		P06BTablas.P06B_P06B20_PATICIPA + "= TO_NUMBER(?), " +
		P06BTablas.P06B_P06B20_DPROFOR + "=?, " +
		P06BTablas.P06B_P06B20_ACTINS + "=?, " +
		P06BTablas.P06B_P06B20_TRASDGS + "= TO_DATE(?,'dd/MM/yyyy'), " +
		P06BTablas.P06B_P06B20_ULTEJERINCORPORADO + "=?, " +
		P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA + "=?" +
		" WHERE " + P06BTablas.P06B_P06B20_NUMEXP + "=?";

	private static String SELECT_BY_PK =
		"SELECT " +
		P06BTablas.P06B_P06B20_NUMEXP + ", " +
		P06BTablas.P06B_P06B20_CLASE + ", " +
		P06BTablas.P06B_P06B20_IDENTIFICADOR + ", " +
		P06BTablas.P06B_P06B20_RAZSOC + ", " +
		P06BTablas.P06B_P06B20_NOMBRE + ", " +
		P06BTablas.P06B_P06B20_APE1 + ", " +
		P06BTablas.P06B_P06B20_APE2 + ", " +
		P06BTablas.P06B_P06B20_DOMICI + ", " +
		P06BTablas.P06B_P06B20_CODMUN + ", " +
		P06BTablas.P06B_P06B20_LOCALI + ", " +
		P06BTablas.P06B_P06B20_CODPRO + ", " +
		P06BTablas.P06B_P06B20_CODPST + ", " +
		P06BTablas.P06B_P06B20_TELEFOT + ", " +
		P06BTablas.P06B_P06B20_TELEFOM + ", " +
		P06BTablas.P06B_P06B20_TELEFOC + ", " +
		P06BTablas.P06B_P06B20_FAX1 + ", " +
		P06BTablas.P06B_P06B20_FAX2 + ", " +
		P06BTablas.P06B_P06B20_MAIL + ", " +
		P06BTablas.P06B_P06B20_WEB + ", " +
		P06BTablas.P06B_P06B20_CURSO + ", " +
		P06BTablas.P06B_P06B20_DENCURSO + ", " +
		P06BTablas.P06B_P06B20_ACREDITA + ", " +
		P06BTablas.P06B_P06B20_DACREDITA + ", " +
		P06BTablas.P06B_P06B20_ESTADO + ", " +
		P06BTablas.P06B_P06B20_FECHAAL + ", " +
		P06BTablas.P06B_P06B20_FECHABAJ + ", " +
		P06BTablas.P06B_P06B20_MOTIVOB + ", " +
		P06BTablas.P06B_P06B20_FECHASUS + ", " +
		P06BTablas.P06B_P06B20_MOTIVOS + ", " +
		P06BTablas.P06B_P06B20_FECFINSU + ", " +
		"TRIM(TO_CHAR(" + P06BTablas.P06B_P06B20_CAPSOC + ",'99G999G999G999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B20_CAPSOC + ", " +
		"TRIM(TO_CHAR(" + P06BTablas.P06B_P06B20_PATICIPA + ",'999G999G999','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B20_PATICIPA + ", " +
		P06BTablas.P06B_P06B20_DPROFOR + ", " +
		P06BTablas.P06B_P06B20_ACTINS + ", " +
		P06BTablas.P06B_P06B20_TRASDGS + ", " +
		P06BTablas.P06B_P06B20_ULTEJERINCORPORADO + ", " +
		P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA + ", " +
		P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE +
		" FROM "+ P06BTablas.P06B_P06B20T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B20_NUMEXP + " = ?";

	private static String SELECT_BY_PK_INCORPORACION =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B20_CLASE + ", "
		+ "A." + P06BTablas.P06B_P06B20_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B20_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B20_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B20_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B20_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B20_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B20_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B20_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B20_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B20_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B20_TELEFOT + ", "
		+ "A." + P06BTablas.P06B_P06B20_TELEFOM + ", "
		+ "A." + P06BTablas.P06B_P06B20_FAX1 + ", "
		+ "A." + P06BTablas.P06B_P06B20_MAIL + ", "
		+ "A." + P06BTablas.P06B_P06B20_WEB + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B20_CAPSOC + ",'99G999G999G999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B20_CAPSOC + ", "

		+ "A." + P06BTablas.P06B_P06B20_TELEFOC + ", "
		+ "A." + P06BTablas.P06B_P06B20_FAX2 + ", "
		+ "A." + P06BTablas.P06B_P06B20_CURSO + ", "
		+ "A." + P06BTablas.P06B_P06B20_DENCURSO + ", "
		+ "A." + P06BTablas.P06B_P06B20_ACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B20_DACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B20_ESTADO + ", "
		+ "A." + P06BTablas.P06B_P06B20_FECHAAL + ", "
		+ "A." + P06BTablas.P06B_P06B20_FECHABAJ + ", "
		+ "A." + P06BTablas.P06B_P06B20_MOTIVOB + ", "
		+ "A." + P06BTablas.P06B_P06B20_FECHASUS + ", "
		+ "A." + P06BTablas.P06B_P06B20_MOTIVOS + ", "
		+ "A." + P06BTablas.P06B_P06B20_FECFINSU + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B20_PATICIPA + ",'999G999G999','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B20_PATICIPA + ", "
		+ "A." + P06BTablas.P06B_P06B20_DPROFOR + ", "
		+ "A." + P06BTablas.P06B_P06B20_ACTINS + ", "
		+ "A." + P06BTablas.P06B_P06B20_TRASDGS + ", "
		+ "A." + P06BTablas.P06B_P06B20_ULTEJERINCORPORADO + ", "
		+ "A." + P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA + ", "
		+ "A." + P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE + ", "

		+ "S." + P06BTablas.P06B_P06B32_IDENTIFICADOR + ", "
		+ "S." + P06BTablas.P06B_P06B32_CLASE + ", "
		+ "S." + P06BTablas.P06B_P06B32_RAZSOC + ", "
		+ "S." + P06BTablas.P06B_P06B32_NOMBRE + ", "
		+ "S." + P06BTablas.P06B_P06B32_APE1 + ", "
		+ "S." + P06BTablas.P06B_P06B32_APE2 + ", "
		+ "S." + P06BTablas.P06B_P06B32_DOMICI + ", "
		+ "S." + P06BTablas.P06B_P06B32_CODMUN + ", "
		+ "S." + P06BTablas.P06B_P06B32_LOCALI + ", "
		+ "S." + P06BTablas.P06B_P06B32_CODPRO + ", "
		+ "S." + P06BTablas.P06B_P06B32_CODPST + ", "
		+ "S." + P06BTablas.P06B_P06B32_TELEFONO + ", "
		+ "S." + P06BTablas.P06B_P06B32_MOVIL + ", "
		+ "S." + P06BTablas.P06B_P06B32_FAX + ", "
		+ "S." + P06BTablas.P06B_P06B32_MAIL + ", "
		+ "S." + P06BTablas.P06B_P06B32_DOMINIO_INTERNET + ", "
		+ "TRIM(TO_CHAR(S." + P06BTablas.P06B_P06B32_CAPSOC + ",'99G999G999G999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B32_CAPSOC
		+ " FROM " + P06BTablas.P06B_P06B20T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B32T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B32_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B32_EJERCICIO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B20_NUMEXP + "=S." + P06BTablas.P06B_P06B32_NUMEXP;

	private static String SELECT_BY_PK_CORRELATENCIONPETICIONENREVISION =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B20_CLASE + ", "
		+ "A." + P06BTablas.P06B_P06B20_IDENTIFICADOR + ", "
		+ "A." + P06BTablas.P06B_P06B20_RAZSOC + ", "
		+ "A." + P06BTablas.P06B_P06B20_NOMBRE + ", "
		+ "A." + P06BTablas.P06B_P06B20_APE1 + ", "
		+ "A." + P06BTablas.P06B_P06B20_APE2 + ", "
		+ "A." + P06BTablas.P06B_P06B20_DOMICI + ", "
		+ "A." + P06BTablas.P06B_P06B20_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B20_LOCALI + ", "
		+ "A." + P06BTablas.P06B_P06B20_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B20_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B20_TELEFOT + ", "
		+ "A." + P06BTablas.P06B_P06B20_TELEFOM + ", "
		+ "A." + P06BTablas.P06B_P06B20_FAX1 + ", "
		+ "A." + P06BTablas.P06B_P06B20_MAIL + ", "
		+ "A." + P06BTablas.P06B_P06B20_WEB + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B20_CAPSOC + ",'99G999G999G999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B20_CAPSOC + ", "

		+ "A." + P06BTablas.P06B_P06B20_TELEFOC + ", "
		+ "A." + P06BTablas.P06B_P06B20_FAX2 + ", "
		+ "A." + P06BTablas.P06B_P06B20_CURSO + ", "
		+ "A." + P06BTablas.P06B_P06B20_DENCURSO + ", "
		+ "A." + P06BTablas.P06B_P06B20_ACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B20_DACREDITA + ", "
		+ "A." + P06BTablas.P06B_P06B20_ESTADO + ", "
		+ "A." + P06BTablas.P06B_P06B20_FECHAAL + ", "
		+ "A." + P06BTablas.P06B_P06B20_FECHABAJ + ", "
		+ "A." + P06BTablas.P06B_P06B20_MOTIVOB + ", "
		+ "A." + P06BTablas.P06B_P06B20_FECHASUS + ", "
		+ "A." + P06BTablas.P06B_P06B20_MOTIVOS + ", "
		+ "A." + P06BTablas.P06B_P06B20_FECFINSU + ", "
		+ "TRIM(TO_CHAR(A." + P06BTablas.P06B_P06B20_PATICIPA + ",'999G999G999','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B20_PATICIPA + ", "
		+ "A." + P06BTablas.P06B_P06B20_DPROFOR + ", "
		+ "A." + P06BTablas.P06B_P06B20_ACTINS + ", "
		+ "A." + P06BTablas.P06B_P06B20_TRASDGS + ", "
		+ "A." + P06BTablas.P06B_P06B20_ULTEJERINCORPORADO + ", "
		+ "A." + P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA + ", "
		+ "A." + P06BTablas.P06B_P06B20_TIPOATENCIONCLIENTE + ", "

		+ "S." + P06BTablas.P06B_P06B70_CO_IDENTIFICADOR + ", "
		+ "S." + P06BTablas.P06B_P06B70_CO_CLASE + ", "
		+ "S." + P06BTablas.P06B_P06B70_CO_RAZSOC + ", "
		+ "S." + P06BTablas.P06B_P06B70_CO_NOMBRE + ", "
		+ "S." + P06BTablas.P06B_P06B70_CO_APE1 + ", "
		+ "S." + P06BTablas.P06B_P06B70_CO_APE2 + ", "
		+ "S." + P06BTablas.P06B_P06B70_CO_DOMICI + ", "
		+ "S." + P06BTablas.P06B_P06B70_CO_CODMUN + ", "
		+ "NULL, "
		+ "S." + P06BTablas.P06B_P06B70_CO_CODPRO + ", "
		+ "S." + P06BTablas.P06B_P06B70_CO_CODPST + ", "
		+ "S." + P06BTablas.P06B_P06B70_CO_TELEFONO + ", "
		+ "NULL, "
		+ "NULL, "
		+ "S." + P06BTablas.P06B_P06B70_CO_MAIL + ", "
		+ "S." + P06BTablas.P06B_P06B70_CO_WEB + ", "
		+ "TRIM(TO_CHAR(S." + P06BTablas.P06B_P06B70_CO_CAPSOC + ",'99G999G999G999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B70_CO_CAPSOC + ", "
		+ "TRIM(TO_CHAR(S." + P06BTablas.P06B_P06B70_CO_PATICIPA + ",'999G999G999','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B70_CO_PATICIPA + ", "
		+ "S." + P06BTablas.P06B_P06B70_CO_TIPOATENCIONCLIENTE
		+ " FROM " + P06BTablas.P06B_P06B20T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B70T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B70_CO_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B70_CO_CORRELATENCPETIC + "=?"
		+ " AND A." + P06BTablas.P06B_P06B20_NUMEXP + "=S." + P06BTablas.P06B_P06B70_CO_NUMEXP;

	private static String SELECT_LISTADO =
		"SELECT  " +
		P06BTablas.P06B_P06B20_NUMEXP + ", " +
		P06BTablas.P06B_P06B20_CLASE + ", " + P06BTablas.P06B_P06B20_IDENTIFICADOR + ", " + P06BTablas.P06B_P06B20_RAZSOC + ", " +
		P06BTablas.P06B_P06B20_NOMBRE + ", " + P06BTablas.P06B_P06B20_APE1 + ", " + P06BTablas.P06B_P06B20_APE2 + ", " +
		P06BTablas.P06B_P06B20_ESTADO +
		" FROM "+ P06BTablas.P06B_P06B20T00_TABLA;

	private static String SELECT_LISTADO2 =
		"SELECT  " +
		P06BTablas.P06B_P06B20_NUMEXP + ", " +
		"TO_CHAR(" + P06BTablas.P06B_P06B20_FECHAAL + ", 'DD/MM/YYYY'), " +
		"TO_CHAR(" + P06BTablas.P06B_P06B20_FECHABAJ + ", 'DD/MM/YYYY'), " +
		P06BTablas.P06B_P06B20_IDENTIFICADOR + ", " +
		"DECODE(" + P06BTablas.P06B_P06B20_CLASE + ",'" + P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA+ "'," + P06BTablas.P06B_P06B20_APE1 + "||' '||" + P06BTablas.P06B_P06B20_APE2 + "||', '||" + P06BTablas.P06B_P06B20_NOMBRE + ", " +
		"DECODE(" + P06BTablas.P06B_P06B20_CLASE + ",'" + P06BConstantes.P06B_AGENTEVINCULADO_FISICA+ "'," + P06BTablas.P06B_P06B20_APE1 + "||' '||" + P06BTablas.P06B_P06B20_APE2 + "||', '||" + P06BTablas.P06B_P06B20_NOMBRE + ", " +
		"DECODE(" + P06BTablas.P06B_P06B20_CLASE + ",'" + P06BConstantes.P06B_CORREDORES_TIPOPER_JURIDICA+ "'," + P06BTablas.P06B_P06B20_RAZSOC + ", " +
		"DECODE(" + P06BTablas.P06B_P06B20_CLASE + ",'" + P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA+ "'," + P06BTablas.P06B_P06B20_RAZSOC +
		",'')))), " +
		P06BTablas.P06B_P06B20_CLASE + ", " +
		P06BTablas.P06B_P06B20_DOMICI + ", " +
		P06BTablas.P06B_P06B20_CODPST + ", " +
		"TO_CHAR(" + P06BTablas.P06B_P06B20_CODPRO + ",'09')," +
		"(SELECT UPPER(DS_O) FROM P06BMUS00 WHERE TO_NUMBER(PROVINCIA_ID)=P06B20_CODPRO AND TO_NUMBER(ID)=P06B20_CODMUN)," +
		P06BTablas.P06B_P06B20_WEB +
		" FROM "+ P06BTablas.P06B_P06B20T00_TABLA +
		" WHERE "+ P06BTablas.P06B_P06B20_ESTADO + " in ('A','S','R','V','B') " +
		" ORDER BY "+ P06BTablas.P06B_P06B20_NUMEXP;

	private static String SELECT_ESTADO_BY_PK =
		"SELECT " +
		P06BTablas.P06B_P06B20_ESTADO +
		" FROM "+ P06BTablas.P06B_P06B20T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B20_NUMEXP + " = ?";

	private static String SELECT_ATENCPETICINCORPORADA_BY_PK =
		"SELECT " +
		P06BTablas.P06B_P06B20_ATENCPETICINCORPORADA +
		" FROM "+ P06BTablas.P06B_P06B20T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B20_NUMEXP + " = ?";
}
